/*------------------------------------------------------------------------------*
 * File Name: MessageBox.c														*
 * Creation: GJL, 7/14/2003														*
 * Purpose: OriginC Source C file for message box example.						*
 * Copyright (c) OriginLab Corp.			2003, 2004, 2005, 2006, 2007		*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/
 
#include <origin.h>

void MessageBoxEx()
{
	int iRet;
	string strMsg;

	// This is an OK/Cancel message box with a question mark icon that
	// is modal with respect to the active Origin window
	iRet = MessageBox(GetWindow(), "Click OK to continue and Cancel to abort.",
		"An OK/Cancel Message Box", MB_OKCANCEL | MB_ICONQUESTION);

	if( IDOK == iRet )
		strMsg =  "You clicked OK.";
	else
		strMsg =  "You clicked Cancel.";

	// This is a modeless OK message box with no icon and a default title
	iRet = MessageBox(NULL, strMsg);
}